# TopoJSON Collection

Converted to TopoJSON from original shapefiles, GeoJSON, etc. as noted in the source. All files are believed to have been converted from sources that are licensed for reuse or which are in the public domain. If you find a file and believe that its original source is not licensed for this type of use, please create an Issue in this repository.

**Please make sure that you click through the links below and download the RAW version of each TopoJson file. Do not right-click on the links below and Save As.**

## World

- World Countries (2014)
  - [world-countries](https://github.com/deldersveld/topojson/blob/master/world-countries.json) [(source)](https://github.com/johan/world.geo.json/blob/master/countries.geo.json)
  - [world-countries (without Antarctica polygon)](https://github.com/deldersveld/topojson/blob/master/world-countries-sans-antarctica.json) [(source)](https://github.com/johan/world.geo.json/blob/master/countries.geo.json)
  - ![](https://raw.githubusercontent.com/deldersveld/topojson/master/images/world-countries.PNG)
- World Continents
  - [world-continents](https://github.com/deldersveld/topojson/blob/master/world-continents.json) [(source)](http://www.naturalearthdata.com/downloads/110m-cultural-vectors)

## Continents
- Africa with Country/Territory Outlines
  - [africa](https://github.com/deldersveld/topojson/blob/master/continents/africa.json) [(source)](http://www.naturalearthdata.com/downloads/110m-cultural-vectors)
- Asia with Country/Territory Outlines
  - [asia](https://github.com/deldersveld/topojson/blob/master/continents/asia.json) [(source)](http://www.naturalearthdata.com/downloads/110m-cultural-vectors)
- Europe with Country/Territory Outlines
  - [europe](https://github.com/deldersveld/topojson/blob/master/continents/europe.json) [(source)](http://www.naturalearthdata.com/downloads/110m-cultural-vectors)
- North America with Country/Territory Outlines
  - [north-america](https://github.com/deldersveld/topojson/blob/master/continents/north-america.json) [(source)](http://www.naturalearthdata.com/downloads/110m-cultural-vectors)
- Oceania with Country/Territory Outlines
  - [oceania](https://github.com/deldersveld/topojson/blob/master/continents/oceania.json) [(source)] (http://www.naturalearthdata.com/downloads/110m-cultural-vectors)
- South America with Country/Territory Outlines
  - [south-america](https://github.com/deldersveld/topojson/blob/master/continents/south-america.json) [(source)](http://www.naturalearthdata.com/downloads/110m-cultural-vectors)


## Algeria
- Provinces / Wilaya
  - [algeria-provinces](https://github.com/deldersveld/topojson/blob/master/countries/algeria/algeria-provinces.json) [(source)](http://www.diva-gis.org/Data)

## Azerbaijan
- Regions
  - [azerbaijan-regions](https://github.com/deldersveld/topojson/blob/master/countries/azerbaijan/azerbaijan-regions.json) [(source)](http://www.diva-gis.org/Data)
- Districts
  - [azerbaijan-districts](https://github.com/deldersveld/topojson/blob/master/countries/azerbaijan/azerbaijan-districts.json) [(source)](http://www.diva-gis.org/Data)
  
## Belgium
- Provinces
  - [belgium-provinces](https://github.com/deldersveld/topojson/blob/master/countries/belgium/belgium-provinces.json) [(source)](http://www.diva-gis.org/Data)
- Arrondissements
  - [belgium-arrondissements](https://github.com/deldersveld/topojson/blob/master/countries/belgium/belgium-arrondissements.json) [(source)](http://www.diva-gis.org/Data)
- Benelux
  - [benelux-countries] (https://github.com/deldersveld/topojson/blob/master/countries/belgium/benelux-countries.json) [(source)](http://www.diva-gis.org/Data)

## China
- Provinces
  - [china-provinces](https://github.com/deldersveld/topojson/blob/master/countries/china/china-provinces.json) [(source)](http://www.diva-gis.org/Data)
  
## Colombia
- Departments
  - [colombia-departments](https://github.com/deldersveld/topojson/blob/master/countries/colombia/colombia-departments.json) [(source)](http://www.diva-gis.org/Data)
  
## Denmark
- Amter - Counties
  - [denmark-counties](https://github.com/deldersveld/topojson/blob/master/countries/denmark/denmark-counties.json) [(source)](http://www.diva-gis.org/Data)
- Kommuner - Municipalities
  - [denmark-municipalities](https://github.com/deldersveld/topojson/blob/master/countries/denmark/denmark-municipalities.json) [(source)](http://www.diva-gis.org/Data)
  
## Finland
- Lääni - Provinces
  - [finland-provinces](https://github.com/deldersveld/topojson/blob/master/countries/finland/finland-provinces.json) [(source)](http://www.diva-gis.org/Data)
- Maakunta - Regions
  - [finland-regions](https://github.com/deldersveld/topojson/blob/master/countries/finland/finland-regions.json) [(source)](http://www.diva-gis.org/Data)
  
## France
- Departments
  - [fr-departments](https://github.com/deldersveld/topojson/blob/master/countries/france/fr-departments.json) [(source)](http://www.diva-gis.org/Data)

## Germany
- Regions
  - [germany-regions](https://github.com/deldersveld/topojson/blob/master/countries/germany/germany-regions.json) [(source)](http://www.diva-gis.org/Data)
- DACH - Countries
  - [dach](https://github.com/deldersveld/topojson/blob/master/countries/germany/dach.json) [(source)](http://www.diva-gis.org/Data)
- DACH - German & Austrian States, Swiss Cantons
  - [dach-states](https://github.com/deldersveld/topojson/blob/master/countries/germany/dach-states.json) [(source)](http://www.diva-gis.org/Data)

## India
- States
  - [india-states](https://github.com/deldersveld/topojson/blob/master/countries/india/india-states.json) [(source)](http://www.diva-gis.org/Data)
- Districts
  - [india-districts](https://github.com/deldersveld/topojson/blob/master/countries/india/india-districts.json) [(source)](http://www.diva-gis.org/Data)

## Ireland
- Counties
  - [ireland-counties](https://github.com/deldersveld/topojson/blob/master/countries/ireland/ireland-counties.json) [(source)](http://www.diva-gis.org/Data)

## Italy
- Regions
  - [italy-regions](https://github.com/deldersveld/topojson/blob/master/countries/italy/italy-regions.json) [(source)](http://www.diva-gis.org/Data)
- Provinces
  - [italy-provinces](https://github.com/deldersveld/topojson/blob/master/countries/italy/italy-provinces.json) [(source)](http://www.diva-gis.org/Data)
  
## Japan
- Prefectures
  - [jp-prefectures](https://github.com/deldersveld/topojson/blob/master/countries/japan/jp-prefectures.json) [(source)](http://www.diva-gis.org/Data)
- Towns
  - [jp-towns](https://github.com/deldersveld/topojson/blob/master/countries/japan/jp-towns.json) [(source)](http://www.diva-gis.org/Data)
  
## Liberia
- Counties
  - [liberia-counties](https://github.com/deldersveld/topojson/blob/master/countries/liberia/liberia-counties.json) [(source)](http://www.diva-gis.org/Data)
- Districts
  - [liberia-districts](https://github.com/deldersveld/topojson/blob/master/countries/liberia/liberia-districts.json) [(source)](http://www.diva-gis.org/Data)
  
## Nepal
- Zones
  - [liberia-counties](https://github.com/deldersveld/topojson/blob/master/countries/nepal/nepal-counties.json) [(source)](http://www.diva-gis.org/Data)
- Districts
  - [liberia-districts](https://github.com/deldersveld/topojson/blob/master/countries/nepal/nepal-districts.json) [(source)](http://www.diva-gis.org/Data)

## Netherlands
- Gemeentegrenzen (2016) - Municipalities
  - [nl-gemeentegrenzen-2016](https://github.com/deldersveld/topojson/blob/master/countries/netherlands/nl-gemeentegrenzen-2016.json) [(source)](http://www.imergis.nl/shp/Gemeentegrenzen_2016_zonder_water.zip)
- Benelux
  - [benelux-countries] (https://github.com/deldersveld/topojson/blob/master/countries/belgium/benelux-countries.json) [(source)](http://www.diva-gis.org/Data)

## New Zealand
- Regional Councils
  - [new-zealand-regional-councils](https://github.com/deldersveld/topojson/blob/master/countries/new-zealand/new-zealand-regional-councils.json) [(source)](http://www.diva-gis.org/Data)
- Districts
  - [new-zealand-districts](https://github.com/deldersveld/topojson/blob/master/countries/new-zealand/new-zealand-districts.json) [(source)](http://www.diva-gis.org/Data)
  
## Norway
- Fylker - Counties
  - [norway-counties](https://github.com/deldersveld/topojson/blob/master/countries/norway/norway-counties.json) [(source)](http://www.diva-gis.org/Data)
- Kommunar - Municipalities
  - [norway-municipalities](https://github.com/deldersveld/topojson/blob/master/countries/norway/norway-municipalities.json) [(source)](http://www.diva-gis.org/Data)

## Pakistan
- Provinces
  - [pakistan-provinces](https://github.com/deldersveld/topojson/blob/master/countries/pakistan/pakistan-provinces.json) [(source)](http://www.diva-gis.org/Data)
- Divisions
  - [pakistan-divisions](https://github.com/deldersveld/topojson/blob/master/countries/pakistan/pakistan-divisions.json) [(source)](http://www.diva-gis.org/Data)
  
## Peru
- Departments
  - [peru-departments](https://github.com/deldersveld/topojson/blob/master/countries/peru/peru-departments.json) [(source)](http://geoservidor.minam.gob.pe/geoservidor/download.aspx)
  
## Philippines
- Provinces / Counties
  - [pakistan-provinces](https://github.com/deldersveld/topojson/blob/master/countries/philippines/philippines-provinces.json) [(source)](http://www.diva-gis.org/Data)
- Municipalities
  - [pakistan-divisions](https://github.com/deldersveld/topojson/blob/master/countries/philippines/philippines-municipalities.json) [(source)](http://www.diva-gis.org/Data)
  
## Poland
- Provinces
  - [poland-provinces](https://github.com/deldersveld/topojson/blob/master/countries/poland/poland-provinces.json) [(source)](http://www.diva-gis.org/Data)
  
## Portugal
- Districts
  - [portugal-districts](https://github.com/deldersveld/topojson/blob/master/countries/portugal/portugal-districts.json) [(source)](http://www.diva-gis.org/Data)
  
## Romania
- Judete - Counties
  - [romania-counties](https://github.com/deldersveld/topojson/blob/master/countries/romania/romania-counties.json) [(source)](http://www.diva-gis.org/Data)

## South Africa
- Provinces
  - [south-africa-provinces](https://github.com/deldersveld/topojson/blob/master/countries/south-africa/south-africa-provinces.json) [(source)](http://www.diva-gis.org/Data)
    
## Spain
- Comunidad
  - [spain-comunidad](https://github.com/deldersveld/topojson/blob/master/countries/spain/spain-comunidad.json) [(source)](http://www.diva-gis.org/Data)
- Comunidad with Canary Islands
  - [spain-comunidad-with-canary-islands](https://github.com/deldersveld/topojson/blob/master/countries/spain/spain-comunidad-with-canary-islands.json) [(source)](http://www.diva-gis.org/Data)
- Provinces
  - [spain-province](https://github.com/deldersveld/topojson/blob/master/countries/spain/spain-province.json) [(source)](http://www.diva-gis.org/Data)
- Provinces with Canary Islands
  - [spain-province-with-canary-islands](https://github.com/deldersveld/topojson/blob/master/countries/spain/spain-province-with-canary-islands.json) [(source)](http://www.diva-gis.org/Data)
- Provinces - Canary Islands only
  - [canary-islands-province](https://github.com/deldersveld/topojson/blob/master/countries/spain/canary-islands-province.json) [(source)](http://www.diva-gis.org/Data)

## Sweden
- Counties
  - [sweden-counties](https://github.com/deldersveld/topojson/blob/master/countries/sweden/sweden-counties.json) [(source)](http://www.diva-gis.org/Data)
- Municipalities
  - [sweden-municipalities](https://github.com/deldersveld/topojson/blob/master/countries/sweden/sweden-municipalities.json) [(source)](http://www.diva-gis.org/Data)
 
## Turkey
  - [turkiye](https://github.com/deldersveld/topojson/blob/master/countries/turkey/turkiye.json) (provided by local contributor)  

## United Arab Emirates
- Emirates
  - [united-arab-emirates](https://github.com/deldersveld/topojson/blob/master/countries/united-arab-emirates/united-arab-emirates.json) [(source)](http://www.diva-gis.org/Data)

## United Kingdom
- Counties
  - [uk-counties](https://github.com/deldersveld/topojson/blob/master/countries/united-kingdom/uk-counties.json) [(source)](http://www.diva-gis.org/Data)

## United States - National

- US Congressional Districts (2015) - TIGER
  - [20m-US-congressional-districts-2015](https://github.com/deldersveld/topojson/blob/master/countries/united-states/lower-quality-20m/20m-US-congressional-districts-2015.json) [(source)](https://catalog.data.gov/dataset/tiger-line-shapefile-2015-nation-u-s-114th-congressional-district-national)
- US Core Based Statistical Areas (2015)- TIGER
  - [20m-US-core-based-statistical-areas-2015](https://github.com/deldersveld/topojson/blob/master/countries/united-states/lower-quality-20m/20m-US-core-based-statistical-areas-2015.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-combined-statistical-area-for-united-states-1-20000000812c2)
- US Counties (2015) - TIGER
  - [20m-US-counties](https://github.com/deldersveld/topojson/blob/master/countries/united-states/lower-quality-20m/20m-US-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- US - Alaska & Hawaii shifted
  - [us-albers](https://github.com/deldersveld/topojson/blob/master/countries/united-states/us-albers.json)
- US Counties - Alaska & Hawaii shifted
  - [us-albers-counties](https://github.com/deldersveld/topojson/blob/master/countries/united-states/us-albers-counties.json)
  - ![](https://raw.githubusercontent.com/deldersveld/topojson/master/images/us-albers-counties.PNG)
- Cartogram of US States by estimated 2014 population
  - [us-cartogram-2014-est-population](https://github.com/deldersveld/topojson/blob/master/countries/united-states/us-cartogram-2014-est-population.json)
  - ![](https://raw.githubusercontent.com/deldersveld/topojson/master/images/us-cartogram-2014-est-population.PNG)

  
## United States - State Level
- **Alabama**
  - Counties
    - [AL-01-alabama-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/AL-01-alabama-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Alaska**
  - Counties
    - [AK-02-alaska-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/AK-02-alaska-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Arizona**
  - Counties
    - [AZ-04-arizona-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/AZ-04-arizona-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Arkansas**
  - Counties
    - [AR-05-arkansas-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/AR-05-arkansas-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **California**
  - Counties
    - [CA-06-california-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/CA-06-california-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Colorado**
  - Counties
    - [CO-08-colorado-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/CO-08-colorado-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Connecticut**
  - Counties
    - [CT-09-connecticut-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/CT-09-connecticut-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Delaware**
  - Counties
    - [DE-10-delaware-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/DE-10-delaware-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Florida**
  - Counties
    - [FL-12-florida-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/FL-12-florida-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Georgia**
  - Counties
    - [GA-13-georgia-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/GA-13-georgia-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Hawaii**
  - Counties
    - [HI-15-hawaii-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/HI-15-hawaii-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Idaho**
  - Counties
    - [ID-16-idaho-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/ID-16-idaho-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Illinois**
  - Counties
    - [IL-17-illinois-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/IL-17-illinois-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Indiana**
  - Counties
    - [IN-18-indiana-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/IN-18-indiana-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Iowa**
  - Counties
    - [IA-19-iowa-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/IA-19-iowa-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Kansas**
  - Counties
    - [KS-20-kansas-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/KS-20-kansas-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Kentucky**
  - Counties
    - [KY-21-kentucky-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/KY-21-kentucky-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Louisiana**
  - Parishes
    - [LA-22-louisiana-parishes](https://github.com/deldersveld/topojson/blob/master/countries/us-states/LA-22-louisiana-parishes.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Maine**
  - Counties
    - [ME-23-maine-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/ME-23-maine-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Maryland**
  - Counties
    - [MD-24-maryland-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/MD-24-maryland-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Massachusetts**
  - Counties
    - [MA-25-massachusetts-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/MA-25-massachusetts-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Michigan**
  - Counties
    - [MI-26-michigan-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/MI-26-michigan-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Minnesota**
  - Counties
    - [MN-27-minnesota-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/MN-27-minnesota-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Mississippi**
  - Counties
    - [MS-28-mississippi-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/MS-28-mississippi-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Missouri**
  - Counties
    - [MO-29-missouri-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/MO-29-missouri-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Montana**
  - Counties
    - [MT-30-montana-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/MT-30-montana-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Nebraska**
  - Counties
    - [NE-31-nebraska-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/NE-31-nebraska-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Nevada**
  - Counties
    - [NV-32-nevada-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/NV-32-nevada-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **New Hampshire**
  - Counties
    - [NH-33-new-hampshire-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/NH-33-new-hampshire-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **New Jersey**
  - Counties
    - [NJ-34-new-jersey-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/NJ-34-new-jersey-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **New Mexico**
  - Counties
    - [NM-35-new-mexico-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/NM-35-new-mexico-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **New York**
  - Counties
    - [NY-36-new-york-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/NY-36-new-york-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **North Carolina**
  - Counties
    - [NC-37-north-carolina-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/NC-37-north-carolina-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **North Dakota**
  - Counties
    - [ND-38-north-dakota-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/ND-38-north-dakota-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Ohio**
  - Counties
    - [OH-39-ohio-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/OH-39-ohio-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Oklahoma**
  - Counties
    - [OK-40-oklahoma-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/OK-40-oklahoma-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Oregon**
  - Counties
    - [OR-41-oregon-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/OR-41-oregon-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Pennsylvania**
  - Counties
    - [PA-42-pennsylvania-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/PA-42-pennsylvania-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Puerto Rico**
  - Municipios
    - [PR-72-puerto-rico-municipios](https://github.com/deldersveld/topojson/blob/master/countries/us-states/PR-72-puerto-rico-municipios.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Rhode Island**
  - Counties
    - [RI-44-rhode-island-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/RI-44-rhode-island-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **South Carolina**
  - Counties
    - [SC-45-south-carolina-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/SC-45-south-carolina-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **South Dakota**
  - Counties
    - [SD-46-south-dakota-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/SD-46-south-dakota-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Tennessee**
  - Counties
    - [TN-47-tennessee-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/TN-47-tennessee-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
  - State Senate Districts 2015
    - [TN-47-tennessee-state-senate-districts-2015](https://github.com/deldersveld/topojson/blob/master/countries/us-states/TN-47-tennessee-state-senate-districts-2015.json) [(source)](https://www.census.gov/cgi-bin/geo/shapefiles/index.php?year=2015&layergroup=State+Legislative+Districts)
  - State House Districts 2015
    - [TN-47-tennessee-state-house-districts-2015](https://github.com/deldersveld/topojson/blob/master/countries/us-states/TN-47-tennessee-state-house-districts-2015.json) [(source)](https://www.census.gov/cgi-bin/geo/shapefiles/index.php?year=2015&layergroup=State+Legislative+Districts)
- **Texas**
  - Counties
    - [TX-48-texas-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/TX-48-texas-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Utah**
  - Counties
    - [UT-49-utah-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/UT-49-utah-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Vermont**
  - Counties
    - [VT-50-vermont-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/VT-50-vermont-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Virginia**
  - Counties
    - [VA-51-virginia-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/VA-51-virginia-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Washington**
  - Counties
    - [WA-53-washington-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/WA-53-washington-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **West Virginia**
  - Counties
    - [WV-54-west-virginia-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/WV-54-west-virginia-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Wisconsin**
  - Counties
    - [WI-55-wisconsin-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/WI-55-wisconsin-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
- **Wyoming**
  - Counties
    - [WY-56-wyoming-counties](https://github.com/deldersveld/topojson/blob/master/countries/us-states/WY-56-wyoming-counties.json) [(source)](https://catalog.data.gov/dataset/2015-cartographic-boundary-file-state-county-for-united-states-1-20000000)
