<!-- Iconified modal -->
<div id="rejected-modal" class="modal fade" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="icon-file-eye mr-2"></i> &nbsp;<?php echo e(trans('app.rejected')); ?></h5>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>

            <div class="modal-body">
                <div
                    class="alert alert-warning alert-dismissible alert-styled-left border-top-0 border-bottom-0 border-right-0"
                    id="rejected-modal-message">
                    <?php echo trans('app.rejected order'); ?>

                </div>
                <hr>
                <form id="rejected-form" method="post">
                    <div class="alert-div"></div>
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id" id="rejected-modal-id">
                </form>
            </div>

            <div class="modal-footer">
                <button class="btn btn-link" data-dismiss="modal"><i
                        class="icon-cross2 font-size-base mr-1"></i> <?php echo e(trans('app.close')); ?></button>
                <button type="submit" form="rejected-form" class="btn bg-info-300"><i
                        class="icon-file-eye font-size-base mr-1"></i> <?php echo e(trans('app.rejected')); ?></button>
            </div>
        </div>
    </div>
</div>
<!-- /iconified modal -->


<?php $__env->startPush('script'); ?>
<script>
    $('.btn-rejected').on('click', function () {
        let id = $(this).data('id');
        let modal = $(this).data('modal');
        let action = "<?php echo e(url('/'.getLocale().'/admin')); ?>";

        action += '/' + modal + '/'+ id + '/' +'rejected';

        $("#rejected-form").attr('action', action);
        $('#rejected-modal-id').val(id);

    });
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/sourceco/esh7nli/resources/views/modals/rejected-modal.blade.php ENDPATH**/ ?>