@extends('layouts.app')

@section('navbar')
    @include('partials.navbar')
@overwrite

@section('sidebar')
    @include('sidebar.index')
@overwrite
@section('content')

    <div class="container">
        <div class="row">
            <div class="container" id="map" style="height:800px;"></div>
        </div>
    </div>
@overwrite
@push('script')
    <script
        src='https://maps.google.com/maps/api/js?language=en&key=AIzaSyDVHXZ7DdC2phLuH-HWiQ8X1J6PeOPEfrU&libraries=places&region=GB'>
    </script >

    <script  type="text/javascript">
        //Set up some of our letiables.
        let map; //Will contain map object.

        let infowindowUser  = new google.maps.InfoWindow();
        let infoWindowtrips  = new google.maps.InfoWindow();

        function initMap() {

            //The center location of our map.
            let centerOfMap = new google.maps.LatLng(33.52821487701718, 36.230283634077374);

            //Map options.
            let options = {
                center: centerOfMap, //Set center.
                zoom: 12, //The zoom value.
                lang: 'ar',
                styles: [
                    {
                        "featureType": "landscape",
                        "stylers": [
                            {
                                "hue": "#FFBB00"
                            },
                            {
                                "saturation": 43.400000000000006
                            },
                            {
                                "lightness": 37.599999999999994
                            },
                            {
                                "gamma": 1
                            }
                        ]
                    },
                    {
                        "featureType": "road.highway",
                        "stylers": [
                            {
                                "hue": "#FFC200"
                            },
                            {
                                "saturation": -61.8
                            },
                            {
                                "lightness": 45.599999999999994
                            },
                            {
                                "gamma": 1
                            }
                        ]
                    },
                    {
                        "featureType": "road.arterial",
                        "stylers": [
                            {
                                "hue": "#FF0300"
                            },
                            {
                                "saturation": -100
                            },
                            {
                                "lightness": 51.19999999999999
                            },
                            {
                                "gamma": 1
                            }
                        ]
                    },
                    {
                        "featureType": "road.local",
                        "stylers": [
                            {
                                "hue": "#FF0300"
                            },
                            {
                                "saturation": -100
                            },
                            {
                                "lightness": 52
                            },
                            {
                                "gamma": 1
                            }
                        ]
                    },
                    {
                        "featureType": "water",
                        "stylers": [
                            {
                                "hue": "#0078FF"
                            },
                            {
                                "saturation": -13.200000000000003
                            },
                            {
                                "lightness": 2.4000000000000057
                            },
                            {
                                "gamma": 1
                            }
                        ]
                    },
                    {
                        "featureType": "poi",
                        "stylers": [
                            {
                                "hue": "#00FF6A"
                            },
                            {
                                "saturation": -1.0989010989011234
                            },
                            {
                                "lightness": 11.200000000000017
                            },
                            {
                                "gamma": 1
                            }
                        ]
                    }
                ]
            };

            //Create the map object.
            map = new google.maps.Map(document.getElementById('map'), options);
        }

        google.maps.event.addDomListener(window, 'load', initMap);

        $(document).ready(function () {
            let markers = [];
            setInterval(function () {
                $.get('/admin/map/users', function (data) {

                    for (let i = 0; i < data.length; i++) {

                        let driver = data[i];
                        // let icon = 'red.png';

                        let marker = new google.maps.Marker({
                            position: new google.maps.LatLng(driver.latitude, driver.longitude),
                            map: map,
                            draggable: false,
                            icon: "/images/taxi.png",
                        });


                        google.maps.event.addListener(marker, 'click', function () {

                            infowindowUser.setContent('<div class="card text-center">' +
                                '<div class="card-body">' +
                                '<div><h3>' +
                                driver.first_name + ' ' +driver.last_name+
                                '</h3></div>' +
                                '<div><h6 class="badge badge-' +
                                ' ">' +
                                '<div><span class="pull-left text-success">{{trans("app.mobile")}} : ' +
                                driver.mobile +
                                '</h6></div>' +
                                '<div><span class="pull-left text-success">{{trans("app.latitude")}} : ' +
                                driver.latitude +
                                '</span> | <span class="pull-right text-danger">{{trans("app.longitude")}} : ' +
                                driver.longitude +
                                '<div><h3>' +
                                driver.status +
                                '</h3></div>'+
                                '</div>'
                            );

                            infowindowUser.open(map, marker);
                        });

                        markers.push(marker);
                    }
                });
            }, 5000);
        });



        $(document).ready(function () {
            let markers = [];
            setInterval(function () {
                $.get('/admin/map/trips', function (data) {

                    for (let i = 0; i < data.length; i++) {

                        let trip = data[i];
                        // let icon = 'red.png';

                        let marker = new google.maps.Marker({
                            position: new google.maps.LatLng(trip.from_latitude, trip.from_longitude),
                            map: map,
                            draggable: false,
                            icon: "/images/close.png",
                        });


                        google.maps.event.addListener(marker, 'click', function () {

                            infoWindowtrips.setContent('<div class="card text-center">' +
                                '<div class="card-body">' +
                                '<div><h3>' +
                                '<div><span class="pull-left text-success">{{trans("app.from_address")}} : ' +
                                trip.from_address +
                                '</h3></div>' +
                                '<div><h3>' +
                                '<div><span class="pull-left text-success">{{trans("app.to_address")}} : ' +
                                trip.to_address +
                                '</h3></div>'+
                                '<div><h6 class="badge badge-' +
                                ' ">' +
                                {{--'<div><span class="pull-left text-success">{{trans("app.mobile")}} : ' +--}}
                                // trip.driver.first_name + ' '+ trip.driver.last_name+
                                '</div>'
                            );

                            infoWindowtrips.open(map, marker);
                        });

                        markers.push(marker);
                    }
                });
            }, 5000);
        });




    </script>
@endpush

