@extends('layouts.front')

@section('content')
    <section id="password" class="add-project pos-relative pt-5 register password grey3-bg">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6 offset-lg-1 col-12 add-form">
                    <form method="POST" action="{{ route('password.email') }}"
                          class="row mr-0 ml-0 w-100 shadow radius-30 white-bg wrap">
                        @csrf
                        <div class="col-12 mb-4">
                            <div class="d-block w-100 form-logo">
                                <img src="{{asset('front/imgs/logo.png')}}"
                                     style="width: 250px"/></div>
                        </div>
                        <div class="col-12 mb-2">
                            <span class="f-big main-text f-bold">{{trans('front.forget password')}}</span>
                        </div>
                        <div class="col-12 pb-3 mb-4 def-border-bottom">
                            <span class="f-extramedium f-med">{{trans('front.dont worry')}}</span>
                        </div>
                        <div class="col-lg-12 col-12 mb-3">
                            <div class="form-group mb-4">
                                <label class="label">
                                    {{trans('front.your email')}} <span class="main-text">*</span>
                                </label>
                                <input value="{{old('email')}}" required name="email" type="email"
                                       class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}"
                                       placeholder="{{trans('front.forget message')}}">
                                @if ($errors->has('email'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="col-12">
                            <button type="submit" class="butn main-butn f-medium next">
                                <span>{{trans('front.recover my password')}}</span>
                            </button>
                        </div>
                        <div class="col-12">
                            <a href="l{{route('login')}}" class="d-inline-block main-text f-normal mt-3"
                               data-toggle="tooltip" title="Let's create one now!">{{trans('front.login')}}</a>
                        </div>
                    </form>
                </div>
                <div class="col-lg-5 col-12">
                    <div class="w-100 h-100 img">
                        <img src="{{asset('front/imgs/icons/password.png')}}" class="w-100"/>
                    </div>
                </div>
            </div>
        </div>
    </section>
@overwrite
