<?php

namespace App\Notifications;

use App\User;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Yusef\Channels\FirebaseMessage;

class LoginNotification extends Notification
{
    use Queueable;

    protected $verify_code, $user;
    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($verify_code, User $user)
    {
        $this->verify_code = $verify_code;
        $this->user = $user;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['fcm'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->line('The introduction to the notification.')
                    ->action('Notification Action', url('/'))
                    ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }

    public function toFcm()
    {
        $title = "";
        $body = "";
        if ($this->user->lang == "ar") {
            $title  = "رمز التأكيد";
            $body = "ان رمز التاكيد  هو : ".$this->verify_code;
        }elseif ($this->user->lang == "en") {
            $title = "Verify Code";
            $body = "Your Verifying code is : ".$this->verify_code;
        }
        $data =[
            "type"=>"register_notification",
            "title"=>$title,
            "body"=>$body,
            "verify_code"=>$this->verify_code,
            "user"=>$this->user->name,
        ];

        $message = new FirebaseMessage();
        $message->data($data);

        $message->priority(FirebaseMessage::PRIORITY_HIGH);

        return $message;
    }
}
