<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreAdmin;
use App\Http\Requests\StoreDriver;
use App\Http\Requests\StoreUser;
use App\Http\Requests\UpdateAdmin;
use App\Http\Requests\UpdateDriver;
use App\User;
use Illuminate\Support\Facades\Session;

class UserController extends CrudController
{
    public function __construct(User $user)
    {
        $this->model = $user;
        $this->route = 'users';

        if (request()->has('role') && request('role') == "admin") {
            $this->title = 'admins';
        }elseif (request()->has('role') && request('role') == "user") {
            $this->title = 'users';
        }elseif (request()->has('role') && request('role') == "driver") {
            $this->title = 'drivers';
        }

        if (request()->has('role') && request('role') == "admin") {

            $this->table_attributes = [
                "name" => "text",
                "status" => "options",
            ];

            $this->attributes = [
                "first_name" => "text",
                "last_name" => "text",
                "mobile" => "text",
                "password" => "text",
                "image" => "image",
            ];

            $this->storeRequest = new StoreAdmin();
            $this->updateRequest = new UpdateAdmin();
        } elseif (request()->has('role') && request('role') == "user") {

            $this->table_attributes = [
                "mobile" => "text",
                "status" => "options",
            ];

            $this->attributes = [
                "mobile" => "text",
            ];

            $this->storeRequest = new StoreUser();
            $this->updateRequest = new StoreUser();
        }elseif (request()->has('role') && request('role') == "driver") {

            $this->table_attributes = [
                "name" => "text",
                "mobile" => "text",
                "balance" => "text",
                "status" => "options",
            ];

            $this->attributes = [
                "first_name" => "text",
                "last_name" => "text",
                "mobile" => "text",
                "image" => "image",

            ];

            $this->storeRequest = new StoreDriver();
            $this->updateRequest = new UpdateDriver();
        }

        if (request()->has('role') && request('role') == "user") {
            $this->actions = [
                'block',
            ];
        }

        if (request()->has('role') && request('role') == "driver") {
            $this->actions = [
                'reset',
            ];
        }
        parent::__construct();
    }


    public function block($id)
    {
        $user = User::find($id);
        if ($user->status == "blocked")
            $user->status = "not_blocked";
        else
            $user->status = "blocked";
        $user->save();
        Session::flash('message', trans('app.success message', ['action' => trans('app.update')]));
        Session::flash('class', 'success');
        return redirect()->back();
    }
    public function showcar($id){

        $user = User::find($id);
        $data['car'] = Car::where('user_id',$id)->first();
        if($data['car']){
            return redirect('/cars/'.$data['car']->id);
        }
        else{
            Session::flash('message', trans('app.nocar', ['action' => trans('app.update')]));
            Session::flash('class', 'danger');
            return redirect()->back();
        }

    }

    public function resetBalance($id)
    {
        $user = User::find($id);
        $user->balance = 0;
        $user->save();

        return redirect()->back();
    }
}
