<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreService;
use App\Service;
use Illuminate\Http\Request;

class ServiceController extends CrudController
{
    public function __construct(Service $service)
    {
        $this->model = $service;
        $this->route = "services";
        $this->title = "services";


        $this->table_attributes = [
          "title"=>"translatable_text",
          "description"=>"translatable_text",
        ];

        $this->attributes = [
            "title"=>"translatable_text",
            "description"=>"translatable_text",
            "image"=>"image",
        ];

        $this->storeRequest = new StoreService();
        $this->updateRequest = new StoreService();


        parent::__construct();
    }
}
