<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreRating;
use App\Rating;
use Illuminate\Http\Request;

class RatingController extends CrudController
{
    public function __construct(Rating $rating)
    {
        $this->route = "ratings";
        $this->title = "ratings";
        $this->model = $rating;

        $this->table_attributes = [
            "order_id"=> "select",
            "rating"=>"text",
            "description"=>"text",
        ];

        $this->attributes = [
            "user_id"=> "select",
            "order_id"=>"select",
            "rating"=>"text",
            "description"=>"translatable_text",
        ];

        $this->actions = [
            "order"
        ];

        $this->storeRequest = new StoreRating();
        $this->updateRequest = new StoreRating();

        parent::__construct();
    }
}
