<?php

namespace App\Http\Controllers;


use App\Address;
use App\Advertisement;
use App\Area;
use App\Car;
use App\Category;
use App\City;
use App\Client;
use App\Contact;
use App\Form;
use App\Governorate;
use App\Notification;
use App\Option;
use App\Order;
use App\Post;
use App\Product;
use App\Project;
use App\Service;
use App\Slide;
use App\Social;
use App\Transaction;
use App\Trip;
use App\User;
use App\Vendor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    public function home()
    {
        $statistics = [];

        $colors = ["text-success-400", "text-danger-400", "text-indigo-400"];

        $item["title"] = "admins";
        $item["route"] = url("/admin/users?role=admin");
        $item["icon"] = "users4";
        $item["color"] = $colors[rand(0, 2)];
        $item["count"] = User::where('role', 'admin')->count();

        array_push($statistics, $item);

        $data["statistics"] = $statistics;

        $item["title"] = "users";
        $item["route"] = url("/admin/users?role=user");
        $item["icon"] = "users4";
        $item["color"] = $colors[rand(0, 2)];
        $item["count"] = User::where('role', 'user')->count();

        array_push($statistics, $item);

        $data["statistics"] = $statistics;

        $item["title"] = "drivers";
        $item["route"] = url("/admin/users?role=driver");
        $item["icon"] = "users4";
        $item["color"] = $colors[rand(0, 2)];
        $item["count"] = User::where('role', 'driver')->count();

        array_push($statistics, $item);

        $data["statistics"] = $statistics;

        $item["title"] = "orders";
        $item["route"] = url("/admin/orders");
        $item["icon"] = "order";
        $item["color"] = $colors[rand(0, 2)];
        $item["count"] = Order::all()->count();

        array_push($statistics, $item);

        $data["statistics"] = $statistics;

        $item["title"] = "pending";
        $item["route"] = url("/admin/orders?status=pending");
        $item["icon"] = "order";
        $item["color"] = $colors[rand(0, 2)];
        $item["count"] = Order::where("status", "pending")->count();

        array_push($statistics, $item);

        $data["statistics"] = $statistics;

        $item["title"] = "under confirmation";
        $item["route"] = url("/admin/orders?status=under_confirmation");
        $item["icon"] = "order";
        $item["color"] = $colors[rand(0, 2)];
        $item["count"] = Order::where("status", "under_confirmation")->count();

        array_push($statistics, $item);

        $data["statistics"] = $statistics;

        $item["title"] = "delivery";
        $item["route"] = url("/admin/orders?status=delivery");
        $item["icon"] = "order";
        $item["color"] = $colors[rand(0, 2)];
        $item["count"] = Order::where("status", "delivery")->count();

        array_push($statistics, $item);

        $data["statistics"] = $statistics;

        $item["title"] = "finished";
        $item["route"] = url("/admin/orders?status=finished");
        $item["icon"] = "order";
        $item["color"] = $colors[rand(0, 2)];
        $item["count"] = Order::where("status", "finished")->count();

        array_push($statistics, $item);

        $data["statistics"] = $statistics;

        $item["title"] = "rejected";
        $item["route"] = url("/admin/orders?status=rejected");
        $item["icon"] = "order";
        $item["color"] = $colors[rand(0, 2)];
        $item["count"] = Order::where("status", "rejected")->count();

        array_push($statistics, $item);

        $data["statistics"] = $statistics;

        $item["title"] = "type of freights";
        $item["route"] = url("/admin/options?type=type_of_freight");
        $item["icon"] = "order";
        $item["color"] = $colors[rand(0, 2)];
        $item["count"] = Option::where("type", "type_of_freight")->count();

        array_push($statistics, $item);

        $data["statistics"] = $statistics;


        $item["title"] = "advertisements";
        $item["route"] = url("/admin/advertisements");
        $item["icon"] = "advertisement";
        $item["color"] = $colors[rand(0, 2)];
        $item["count"] = Advertisement::all()->count();

        array_push($statistics, $item);

        $data["statistics"] = $statistics;

        return view('home')->with($data);
    }

    public function profile()
    {
        $attributes = [
            "first_name" => "text",
            "last_name" => "text",
            "email" => "text",
            "mobile" => "text",
            "image" => "image",
        ];

        $route = "users";

        return view('profile')->with(['attributes' => $attributes, 'route' => $route, 'action' => [], 'item' => Auth::user()]);

    }

    public function resetPassword(Request $request){
        $user = Auth::user();

        if(Hash::check($request->old_password, $user->password)){
            // chech if new password is equal to the old password
            if(Hash::check($request->password, $user->password)){
                Session::flash('message', trans('app.same password'));
                Session::flash('class', 'danger');

                return redirect()->back();
            }
            // check if the new password containt app name or user id
            if(str_contains($request->password, 'eshhanli') || str_contains($request->password, $user->id)){
                Session::flash('message', trans('app.contain app name'));
                Session::flash('class', 'danger');

                return redirect()->back();
            }

            $user->password = bcrypt($request->password);
            $user->save();

            Session::flash('message', trans('app.password success'));
            Session::flash('class', 'success');

            return redirect()->back();


        } else {
            Session::flash('message', trans('app.old password error'));
            Session::flash('class', 'danger');

            return redirect()->back();
        }
    }
}
