<?php

use App\Form;
use App\Language;
use App\Notification;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use App\User;

function storeNotification($request, $user, $order, $type, $title_en, $title_ar, $body_en, $body_ar)
{
    $notification = new Notification();
    $notification->fill($request->except($notification->translatable));
    if (!is_null($notification->translatable)) {
        foreach ($notification->translatable as $attr) {
            $trans = [];
            foreach (Language::all() as $language) {
                $var = $attr . "_" . $language->code;
                if ($var == "title_ar") {
                    $trans[$language->code] = $title_ar;
                } elseif ($var == "body_ar") {
                    $trans[$language->code] = $body_ar;
                } elseif ($var == "title_en") {
                    $trans[$language->code] = $title_en;
                } elseif ($var == "body_en") {
                    $trans[$language->code] = $body_en;
                }
            }
            $notification->$attr = $trans;
        }
    }

    $notification->type = $type;
    $notification->user_id = $user->id;
    $notification->order_id = $order->id;
    $notification->save();

    return $notification;
}

function generateRandomString($length = 20)
{
    $characters = '0123456789';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}


function getClosestDriver($trip)
{
    $query = User::query();
    $query->where('role', 'driver')->where('status', 'online');

    $drivers = $query->whereDoesntHave('driverTrips', function ($query) use ($trip) {
        $query->where('parent_id', $trip->id)->where('status', ['rejected', 'canceled_by_system']);
    })->get();

    $drivers = $drivers->sort(function ($a, $b) use ($trip) {
        if (getDistance($a->latitude, $a->longitude, $trip->from_latitude, $trip->from_longitude) == getDistance($b->latitude, $b->longitude, $trip->from_latitude, $trip->from_longitude)) {
            return 0;
        }
        return (getDistance($a->latitude, $a->longitude, $trip->from_latitude, $trip->from_longitude) > getDistance($b->latitude, $b->longitude, $trip->from_latitude, $trip->from_longitude)) ? 1 : -1;
    });

    return $drivers->first();
}

function is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)
{
    $c = false;
    for ($i = 0, $j = $points_polygon - 1; $i < $points_polygon; $j = $i++) {
        if ((($vertices_y[$i] > $latitude_y != ($vertices_y[$j] > $latitude_y)) &&
            ($longitude_x < ($vertices_x[$j] - $vertices_x[$i]) * ($latitude_y - $vertices_y[$i]) / ($vertices_y[$j] - $vertices_y[$i]) + $vertices_x[$i])))
            $c = true;
    }
    return $c;
}

function getDistance($dlat, $dlng, $lat, $lng)
{
    $r = 6371;

    $dLat = deg2rad($lat - $dlat);
    $dLon = deg2rad($lng - $dlng);

    $a = sin($dLat / 2) * sin($dLat / 2) +
        cos(deg2rad($dlat)) * cos(deg2rad($lat)) *
        sin($dLon / 2) * sin($dLon / 2);

    $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
    $d = $r * $c; // Distance in km

    return $d;
}

function getLocale()
{
    return LaravelLocalization::getCurrentLocale();
}

function getLayoutData()
{
    $data = [];
    return $data;
}

function getBoolean($value)
{
    if ($value) {
        return getLocale() == "ar" ? 'نعم' : 'Yes';
    } else {
        return getLocale() == "ar" ? 'لا' : 'No';
    }

}

function getTranslatedAttribute($item, $attribute)
{
    $var = $attribute . "_" . app()->getLocale();
    return isset($item->$var) ? $item->$var : '';
}

function getOption($type, $code, $lang = null)
{
    $option = \App\Option::where('type', $type)->where('code', $code)->first();

    if ($option)
        return $option->text;
    else
        return '';
}

function getItemTranslatedValue($item)
{
    $name_var = "name_" . getLocale();
    $title_var = "title_" . getLocale();

    if (isset($item->$name_var))
        return $item->$name_var;
    else if (isset($item->$title_var))
        return $item->$title_var;
    else
        return $item->name;
}

function getItemAttributeValue($route, $item, $attribute)
{
    $booleans = ['active'];
    if (in_array($attribute, $booleans))
        return getBoolean($item->$attribute);

    $attr = $attribute . '_' . getLocale();

    if (isset($item->$attr))
        return $item->$attr;

    switch ($route) {
        case "users" :
            switch ($attribute) {
                case "role":
                    return getOption("roles", $item->$attribute);
                case "status":
                    return getOption("user_status", $item->$attribute);
            }
            break;
        case "orders" :
            switch ($attribute) {
                case "status":
                    return getOption("order_status", $item->$attribute);
                case "type":
                    return getOption("type_of_freight", $item->$attribute);
                case "type_of_payment":
                    return getOption("type_of_payment", $item->$attribute);
                case "client_id";
                    return $item->user ? $item->user->mobile : '';
                case "is_breakable";
                    return getOption("is_breakable", $item->$attribute);
            }
            break;
        case "notifications" :
            switch ($attribute) {
                case "user_id";
                    return $item->user ? $item->user->mobile : '';
            }
            break;

        case "posts" :
            switch ($attribute) {
                case "type";
                    return getOption("posts_types", $item->$attribute);
            }
            break;
        case "ratings" :
            switch ($attribute) {
                case "order_id";
                    return $item->order ? $item->order->id : '';
                case "user_id";
                    return $item->user ? $item->user->mobile : '';
            }
            break;
        case "states" :
            switch ($attribute) {
                case "user_id";
                    return $item->user ? $item->user->mobile : '';
                case "order_id";
                    return $item->order ? $item->order->id : '';
                case "status_id";
                    return $item->order ? $item->order->status : '';

            }
            break;
    }

    return $item->$attribute;
}

function getAttributeType($attribute)
{
    switch ($attribute) {
        case 'email' :
            return 'email';
        default :
            return 'text';
    }
}

function getItemData($item_id, $item_type)
{
    if ($item_type == "role") {
        $item = \App\Option::where('code', $item_id)->first();
        if ($item)
            return $item->text;
    }

    if ($item_type == "type") {
        $item = \App\Option::where('code', $item_id)->first();
        if ($item)
            return $item->text;
    }

    return "";
}

function getHasRelationAttributes($route, $relation)
{
    $route = substr($route, 0, -1);
    $model = "App\\" . ucfirst($route);

    if (class_exists($model)) {
        $item = new $model();
        $relation = $item->$relation();
        $related = get_class($relation->getRelated());
        $item = new $related();
        $attributesFiled = $route . 'Attributes';
        $attributes = $item->$attributesFiled;
    }

    return is_null($attributes) ? [] : $attributes;
}

function getSelectItems($route, $attribute)
{
    $data = [];
    switch ($route) {
        case 'orders' :
            switch ($attribute) {
                case'client_id':
                    $data = \App\User::where("role", "user")->get();
                    break;
            }
            break;
        case 'ratings' :
            switch ($attribute) {
                case'order_id':
                    $data = \App\Order::all();
                    break;
                case'user_id':
                    $data = \App\User::where("role", "user")->get();
                    break;
            }
            break;
        case 'notifications' :
            switch ($attribute) {
                case'user_id':
                    $data = \App\User::where("role", "user")->get();
                    break;
            }
            break;

        case 'states' :
            switch ($attribute) {
                case'user_id':
                    $data = \App\User::where("role", "user")->get();
                    break;
                case'order_id':
                    $data = \App\Order::all();
                    break;
            }
            break;


    }
    return $data;
}

function getSelectOptions($route, $attribute)
{
    $options = [];

    if ($attribute == "active")
        return \App\Option::where('type', 'booleans')->get();

    if ($attribute == "order")
        return generateOrderOptions();

    switch ($route) {
        case 'users':
            switch ($attribute) {
                case'role':
                    $options = \App\Option::where('type', 'roles')->get();
                    break;
                case'country':
                    $options = \App\Option::where('type', 'countries')->get();
                    break;
                case'type':
                    $options = \App\Option::where('type', 'users_types')->get();
                    break;
                case'status':
                    $options = \App\Option::where('type', 'user_status')->get();
                    break;
            }
            break;
        case "orders" :
            switch ($attribute) {
                case "type" :
                    $options = \App\Option::where("type", "type_of_freight")->get();
                    break;
                case "type_of_payment" :
                    $options = \App\Option::where("type", "type_of_payment")->get();
                    break;
                case "status" :
                    $options = \App\Option::where("type", "order_status")->get();
                    break;
                case "is_breakable" :
                    $options = \App\Option::where("type", "is_breakable")->get();
                    break;
            }
            break;
        case "posts" :
            switch ($attribute) {
                case "type" :
                    $options = \App\Option::where("type", "posts_types")->get();
                    break;

            }
            break;

        case "states" :
            switch ($attribute) {
                case "status" :
                    $options = \App\Option::where("type", "order_status")->get();
                    break;

            }
    }


    return $options;
}

function generateOrderOptions()
{
    $options = [];

    $collection = new \Illuminate\Database\Eloquent\Collection();
    for ($i = 0; $i < 10; $i++) {
        $collection->add(new \App\Option(['code' => $i, 'text_ar' => $i, 'text_en' => $i]));
    }

    return $options;
}

function getActionIcon($action)
{
    switch ($action) {
        case "block" :
            return "user-block";
        case "approve":
        case "done" :
            return "checkmark-circle2";
        case "rejected" :
        case "unblock" :
        case "disable" :
            return "close2";
        case "transactions" :
            return "list";
        default :
            return "hash";
    }
}

function getIndexOperations($model)
{
    if ($model instanceof \App\Rating)
        return [];
    return ["create"];
}

function getRouteString($params)
{
    $string = "&";
    foreach ($params as $key => $value) {
        $string .= $key . "=" . $value . "&";
    }

    return $string;
}

function getRouteParameters()
{
    $query_string = '?';
    if (request()->has('type'))
        $query_string .= 'type=' . request('type');
    if (request()->has('status'))
        $query_string .= '&status=' . request('status');
    if (request()->has('canceled'))
        $query_string .= '&canceled=' . request('canceled');
    if (request()->has('role'))
        $query_string .= '&role=' . request('role');
    return $query_string;
}

function getNotificationIcon($item)
{

    $notification = '<a href="';
    $notification .= route('notifications.show', $item->id);
    $notification .= '" class="btn bg-success-400 rounded-round btn-icon">';

    switch ($item->type) {
        default:
            $notification .= '<i class="icon-mention"></i>';
    }

    $notification .= '</a>';

    return $notification;
}

function getPlural($model)
{
    switch ($model) {
        case "category" :
            return "categories";
        case "city" :
            return "cities";
        case "postCategory" :
            return "postCategories";
        default :
            return $model . "s";
    }
}

